const { Sequelize } = require("sequelize");
const sequelize = require("../config/dbseq.js");
const { DataTypes } = Sequelize;

const ClientShare = sequelize.define(
  "client_shortlist",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
    client_name: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "no name",
    },
    client_project: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "no name",
    },
    client_project_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: null,
    },
    client_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: "clients",
        key: "id",
      },
    },
    client_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: Sequelize.literal("CURRENT_TIMESTAMP"),
    },
    client_token: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "null",
    },
    client_shortlist_name: {
      type: DataTypes.STRING(1000),
      allowNull: true,
      defaultValue: "no name",
    },
    client_data: {
      type: DataTypes.STRING(5000),
      allowNull: true,
    },
    client_notes: {
      type: DataTypes.STRING(1000),
      allowNull: true,
    },
    client_linked: {
      type: DataTypes.BOOLEAN,
      defaultValue: 1,
    },
    customer_notes: {
      type: DataTypes.STRING(1000),
      allowNull: true,
    },
  },
  {
    freezeTableName: true,
    tableName: "client_shortlist",
    timestamps: false, // Disable the automatic addition of createdAt and updatedAt fields
  }
);

ClientShare.sync({ alter: true });
module.exports = ClientShare;
