const { Sequelize } = require("sequelize");
const sequelize = require("../config/dbseq.js");
const { DataTypes } = Sequelize;

const Clients = sequelize.define(
  "clients",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
    client_name: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "no name",
    },
    client_contact_name: {
      type: DataTypes.STRING(250),
      allowNull: true,
      defaultValue: "no contact name",
    },
    client_id: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "no id",
    },
    client_address: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "no address",
    },
    client_email: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "no-email@email.com",
    },
    prefix: {
      type: DataTypes.STRING(5),
      allowNull: true,
      defaultValue: "+40",
    },
    client_phone: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: "12345678",
    },
    client_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: Sequelize.literal("CURRENT_TIMESTAMP"),
    },
    client_update: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: Sequelize.literal("CURRENT_TIMESTAMP"),
    },
    client_active: {
      type: DataTypes.TINYINT,
      allowNull: true,
      defaultValue: 0,
    },
    client_notes: {
      type: DataTypes.TEXT,
      allowNull: true,
      defaultValue: "no notes",
    },
    client_profileimage: {
      type: DataTypes.TEXT,
      allowNull: true,
      defaultValue: "no image",
    },
    customer_notes: {
      type: DataTypes.TEXT,
      allowNull: true,
      defaultValue: "no notes",
    },
  },
  {
    freezeTableName: true,
    tableName: "clients",
    timestamps: false, // Disable the automatic addition of createdAt and updatedAt fields
  }
);

Clients.sync({ alter: true });
module.exports = Clients;
