const { Sequelize } = require("sequelize");
const sequelize = require("../config/dbseq.js");
const { DataTypes } = Sequelize;

const ClientsRoutes = sequelize.define(
  "shared_routes",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
    cid: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    sid: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: "client_shortlist",
        key: "id",
      },
    },
    path: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "no name",
    },
    element: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "<SharedShortList />",
    },
    exact: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: true,
    },
    client_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: Sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    freezeTableName: true,
    tableName: "shared_routes",
    timestamps: false, // Disable the automatic addition of createdAt and updatedAt fields
  }
);

ClientsRoutes.sync({ alter: true });
module.exports = ClientsRoutes;
