const { Sequelize } = require("sequelize");
const sequelize = require("../config/dbseq.js");
const { DataTypes } = Sequelize;

const ExtraFeats = sequelize.define(
  "extrafeats",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    category: DataTypes.STRING(100),
    feat: {
      type: DataTypes.STRING(100),
      allowNull: false,
      // unique: true,
    },
    userId: DataTypes.INTEGER(100),
  },
  {
    freezeTableName: true,
  }
);
ExtraFeats.sync({ alter: true });
module.exports = ExtraFeats;
