const { Sequelize } = require("sequelize");
const sequelize = require("../config/dbseq.js");
const { DataTypes } = Sequelize;

const ExtraFilters = sequelize.define(
  "extrafilters",
  {
    extra_filter_id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    extra_filter_name: DataTypes.STRING(100),
    extra_filter_data: {
      type: DataTypes.STRING(1000),
      allowNull: true,
    },
    extra_filter_uid: DataTypes.INTEGER(11),
    extrafeatid: DataTypes.INTEGER(255),
  },
  {
    freezeTableName: true,
  }
);
ExtraFilters.sync({ alter: true });
module.exports = ExtraFilters;
