const { Sequelize } = require("sequelize");
const sequelize = require("../config/dbseq.js");
const { DataTypes } = Sequelize;

const FeatureType = sequelize.define(
  "feature_type",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    ftype: DataTypes.INTEGER(3),
    ftype_name: DataTypes.STRING(255),
    ftype_color: DataTypes.STRING(100),
  },
  {
    freezeTableName: true,
    createdAt: false,
    updatedAt: false,
  }
);
FeatureType.sync({ alter: true });
module.exports = FeatureType;
