const { Sequelize } = require("sequelize");
const sequelize = require("../config/dbseq.js");
const { DataTypes } = Sequelize;

const Feature = sequelize.define(
  "features",
  {
    extrafeatid: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    fid: DataTypes.INTEGER(10),
    ftype: DataTypes.INTEGER(3),
    id: {
      type: DataTypes.INTEGER(10),
      defaultValue: 0,
    },
    name: DataTypes.STRING(100),
    feat: {
      type: DataTypes.STRING(50),
      //unique: true
    },
    userId: DataTypes.INTEGER(10),
  },
  {
    freezeTableName: true,
  }
);
Feature.sync({ alter: true });
module.exports = Feature;
