const { Sequelize } = require("sequelize");
const sequelize = require("../config/dbseq.js");
const { DataTypes } = Sequelize;

const Filters = sequelize.define(
  "filters",
  {
    filter_id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    filter_map: DataTypes.STRING(100),
    filter_name: DataTypes.STRING(5000),
    filter_data: DataTypes.STRING(5000),
    filter_type: {
      type: DataTypes.STRING(1000),
      allowNull: true,
    },
    filter_uid: DataTypes.INTEGER(11),
  },
  {
    freezeTableName: true,
  }
);
Filters.sync({ alter: true });
module.exports = Filters;
