const { Sequelize } = require("sequelize");
const sequelize = require("../config/dbseq.js");
const { DataTypes } = Sequelize;

const Image = sequelize.define(
  "galleries",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    gid: DataTypes.INTEGER(10),
    image: DataTypes.STRING(5000),
    userId: DataTypes.INTEGER(10),
    featureId: DataTypes.INTEGER(10),
  },
  {
    freezeTableName: true,
  }
);

// Define a function to reset auto-increment value
const resetAutoIncrement = async () => {
  try {
    await sequelize.query("ALTER TABLE galleries AUTO_INCREMENT = 1;");
    console.log("Auto-increment value reset successfully");
  } catch (error) {
    console.error("Error resetting auto-increment value:", error);
  }
};

// Call the resetAutoIncrement function after syncing the model
Image.sync({ alter: true }).then(() => {
  //resetAutoIncrement();
});

module.exports = Image;
