const { Sequelize } = require("sequelize");
const sequelize = require("../config/dbseq.js");
const { DataTypes } = Sequelize;

const Nationality = sequelize.define(
  "nationality",
  {
    nid: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    abreviation: DataTypes.STRING(4),
    nationality: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    flag: DataTypes.STRING(500),
    userId: DataTypes.INTEGER(5),
  },
  {
    freezeTableName: true,
  }
);
Nationality.sync({ alter: true });
module.exports = Nationality;
