const { Sequelize } = require("sequelize");
const sequelize = require("../config/dbseq.js");
const { DataTypes } = Sequelize;

const Profiles = sequelize.define(
  "profiles",
  {
    pid: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    age: DataTypes.STRING(3),
    height: DataTypes.INTEGER(3),
    profilename: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    talentname: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    profileimage: {
      type: DataTypes.STRING(1000),
      allowNull: true,
    },
    userid: DataTypes.INTEGER(100),
    uid: DataTypes.INTEGER(3),
    setstate: {
      type: DataTypes.INTEGER(1),
      defaultValue: 0,
    },
  },
  {
    freezeTableName: true,
    truncate: true,
    restartIdentity: true,
  }
);
Profiles.sync({ alter: true });
module.exports = Profiles;
