const { Sequelize } = require("sequelize");
const sequelize = require("../config/dbseq.js");
const { DataTypes } = Sequelize;

const ProjectsTalents = sequelize.define(
  "projects_talents",
  {
    talent_id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    talent_project_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: "projects",
        key: "project_id",
      },
    },
    talent_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: Sequelize.literal("CURRENT_TIMESTAMP"),
    },
    talent_update: {
      type: DataTypes.DATEONLY,
      allowNull: true,
      defaultValue: Sequelize.literal("CURRENT_TIMESTAMP"),
    },
    talent_total_amount: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    talent_total_payed: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    talent_due: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },

    talent_state: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
      validate: {
        min: 0,
        max: 3,
      },
    },
    talent_notes: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: "no comment",
    },
    currency: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: "RON",
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: "users",
        key: "id",
      },
    },
  },
  {
    freezeTableName: true,
    timestamps: false, // If you don't want timestamps like createdAt and updatedAt
  }
);
//ProjectsTalents.sync({ alter: true });
module.exports = ProjectsTalents;
