const { Sequelize } = require("sequelize");
const sequelize = require("../config/dbseq.js");
const { DataTypes } = Sequelize;

const ShortList = sequelize.define(
  "shortlist",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    shortlist_id: DataTypes.INTEGER(11),
    shortlist_name: DataTypes.STRING(255),
    shortlist_img: DataTypes.STRING(500),
    shortlist_data: DataTypes.STRING(5000),
  },
  {
    freezeTableName: true,
  }
);
ShortList.sync({ alter: true });
module.exports = ShortList;
