const { Sequelize, Op } = require("sequelize");
const sequelize = require("../config/dbseq.js");
const { DataTypes } = Sequelize;

//module.exports = (sequelize, DataTypes) => {
const User = sequelize.define(
  "users",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    username: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    email: {
      type: DataTypes.STRING(100),
      allowNull: true,
      //      allowNull: false,
      //  unique: true,
      /*  validate: {
        //     isEmail: true,
        //    {} msg: "Must be an EMAIL ##CUSTOM MESSAGE##",}
        // len: [5, 10],
      },*/
      //  unique: { args: true, msg: "Email already exists" },
    },
    password: { type: DataTypes.STRING(500), allowNull: true },
    role: { type: DataTypes.INTEGER(3), defaultValue: 3, allowNull: true },
    prefix: { type: DataTypes.STRING(5), defaultValue: "+40", allowNull: true },
    phone: {
      type: DataTypes.INTEGER(20),
      defaultValue: 1000000000,
      allowNull: true,
    },
    firstname: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "no firstname",
    },
    lastname: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "no lastname",
    },
    address: { type: DataTypes.STRING(1000), allowNull: true },
    id_card: {
      type: DataTypes.STRING(500),
      allowNull: true,
      defaultValue: "no id card",
    },
    birthyear: {
      type: DataTypes.INTEGER(4),
      defaultValue: 1970,
    },
    age: { type: DataTypes.INTEGER(3), allowNull: true, defaultValue: 20 },
    height: {
      type: DataTypes.INTEGER(3),
      allowNull: true,
      defaultValue: 175,
    },
    shoe: { type: DataTypes.INTEGER(2), allowNull: true, defaultValue: 38 },
    clothes: {
      type: DataTypes.INTEGER(2),
      allowNull: true,
      defaultValue: 3,
    },
    gender: { type: DataTypes.INTEGER(1), allowNull: true, defaultValue: 1 },
    profileimage: { type: DataTypes.STRING(500), allowNull: true },
    exclusive: {
      type: DataTypes.INTEGER(1),
      defaultValue: 0,
      allowNull: true,
    },
    startingdate: { type: DataTypes.STRING(100), allowNull: true },
    endingdate: { type: DataTypes.STRING(100), allowNull: true },
    active: {
      type: DataTypes.BOOLEAN,
      defaultValue: 1,
      allowNull: false,
    },
    selectuser: {
      type: DataTypes.INTEGER(1),
      defaultValue: 0,
      allowNull: true,
    },
    parent: {
      type: DataTypes.BOOLEAN,
      defaultValue: 0,
      allowNull: false,
    },
    professional: {
      type: DataTypes.BOOLEAN,
      defaultValue: 0,
      allowNull: false,
    },
    createdAt: DataTypes.DATE(6),
    updatedAt: DataTypes.DATE(6),
    usertext: { type: DataTypes.STRING(1000), allowNull: true },
  },
  /*
  {
    hooks: {
      beforeCreate: async (schema) => {
        console.log(schema.username);
        if (schema.username === undefined) {
          delete schema.username;
        }
      },
    },
  },
  */
  {
    freezeTableName: true,
    timestamps: true,
    //  individualHooks: true,
  }
);
User.sync({ alter: true });
module.exports = User;
